
*The Effects of Fiscal Measures During Covid-19* 
*Pragyan Deb, Davide Furceri, Jonathan D. Ostry, Nour Tawk, Naihan Yang* 

*Results to Tables 1-4 in the main text* 

global MYDATA "C:\Users\ntawk\Desktop\JMCB final\finalforjmcb"
global SAVING "C:\Users\ntawk\Desktop\JMCB final\finalforjmcb\results" 

cd $ME
clear all
set maxvar 120000

* Load data
use "$MYDATA\Monthly_dta_toJMCB.dta", clear
cd "C:\Users\ntawk\Desktop\JMCB final\finalforjmcb\results"


///////////////////
*Table 1* Baseline 
//////////////////
foreach shock in fp_res_frn{
foreach dep in gip pmi_manu g_cli  c_unemp cds_scaled{

xtscc `dep' `shock' c.month#code mes c pr_change mp_gdp vix_level, fe lag(10)
outreg2 using table1.xls, bdec(3) addstat ("R-squared", e(r2_w)) ctitle(`dep') append

}
}


///////////////////
*Table 2* Country characteristics 
//////////////////

*1. AE vs EM* 
foreach dep in gip {
foreach shock in fp_res_frn {

xtscc `dep' c.AE#c.(`shock') c.EMDE#c.(`shock') c mes pr_change mp_gdp vix_level c.month#code, fe lag(10)
outreg2 using table2.xls, bdec(3)  addstat ("R-squared", e(r2_w)) ctitle(Industrial Production (y-o-y growth)) replace	
	
}
}

 *2. Debt to GDP*
*interaction variable* 
local inter debttogdp
local fname debt_gdp

* Continuous
egen ave=mean(`inter')
egen sd=sd(`inter')
gen z = (`inter'-ave)/sd if !mi(`inter')
gen dl=exp(-1.5*z)/(1+exp(-1.5*z)) if !mi(`inter')
gen dh=1-dl if !mi(`inter')

drop ave sd z
xtset code month

foreach dep in gip {

* shock variable
local shock fp_res_frn
local control c.month#code

	xtscc `dep' c.dh#c.(`shock') c.dl#c.(`shock') c mes pr_change mp_gdp vix_level c.month#code, fe lag(11)
	outreg2 using table2.xls, bdec(3)  addstat ("R-squared", e(r2_w)) ctitle(Industrial Production (y-o-y growth)) append
	
}
   drop dh dl

************************************
**3. Trade Openness** 
************************************
*interaction variable* 
local inter openness_2
*label variable `inter' "Trade Openness "
local fname trade

* Continious
egen ave=mean(`inter')
egen sd=sd(`inter')
gen z = (`inter'-ave)/sd if !mi(`inter')
gen dl=exp(-1.5*z)/(1+exp(-1.5*z)) if !mi(`inter')
gen dh=1-dl if !mi(`inter')

drop ave sd z
xtset code month

foreach dep in gip {

* shock variable
local shock fp_res_frn

	xtscc `dep' c.dh#c.(`shock') c.dl#c.(`shock') mes c pr_change mp_gdp vix_level c.month#code, fe lag(10)
	outreg2 using table2.xls, bdec(3)  addstat ("R-squared", e(r2_w)) ctitle(Industrial Production (y-o-y growth)) append

}

 drop dh dl 
 
/////////////////////////////////////////////////////////
** Table 3* Above vs Below the line measures, Lifelines vs Demand Support 
////////////////////////////////////////////////////////

foreach shock in fp_res_frn{
foreach dep in gip {

gen emergency_fiscal= emergency_dummy*`shock'
gen demand_fiscal= demand_dummy*`shock'

gen above_fiscal= above_dummy*`shock'
gen below_fiscal= below_dummy*`shock'

xtscc `dep' `shock' c.month#code mes c pr_change mp_gdp vix_level , fe lag(10)
outreg2 using table3.xls, bdec(3)  addstat ("R-squared", e(r2_w))  ctitle(`dep') append

xtscc `dep' emergency_fiscal demand_fiscal  c.month#code mes c pr_change mp_gdp vix_level, fe lag(10)
outreg2 using table3.xls, bdec(3) addstat ("R-squared", e(r2_w))  ctitle(`dep') append

xtscc `dep' above_fiscal below_fiscal  c.month#code mes c pr_change mp_gdp vix_level, fe lag(10)
outreg2 using table3.xls, bdec(3)  addstat ("R-squared", e(r2_w))  ctitle(`dep') append

}
}

drop emergency_fiscal demand_fiscal above_fiscal below_fiscal 


//////////////////////////////////////////////
*Table 4. Effect of announced fiscal shocks, interaction with containment measures 
//////////////////////////////////////////////

*1. Containment Measures** 
local inter mes
label variable `inter' "Containment measures"
local fname mes

* Continious
by code, sort: egen ave=mean(`inter')
by code, sort: egen sd=sd(`inter')
gen z = (`inter'-ave)/sd if !mi(`inter')
gen dl=exp(-1.5*z)/(1+exp(-1.5*z)) if !mi(`inter')
gen dh=1-dl if !mi(`inter')

drop ave sd z
xtset code month


foreach dep in gip {

* Number of lags
local MaxLPLags 1

* shock variable
local shock fp_res_frn

gen above_fiscal= above_dummy*`shock'
gen below_fiscal= below_dummy*`shock'

gen emergency_fiscal= emergency_dummy*`shock'
gen demand_fiscal= demand_dummy*`shock'
	
	xtscc `dep' c.dh#c.(`shock') c.dl#c.(`shock') c pr_change mp_gdp vix_level c.month#code, fe lag(10)
	outreg2 using table4.xls, bdec(3)  addstat ("R-squared", e(r2_w)) ctitle(Industrial Production (y-o-y growth)) replace

	xtscc `dep' c.dh#c.emergency_fiscal c.dl#c.emergency_fiscal c.dh#c.demand_fiscal c.dl#c.demand_fiscal c pr_change mp_gdp vix_level c.month#code, fe lag(10)
	outreg2 using table4.xls, bdec(3)  addstat ("R-squared", e(r2_w)) ctitle(Industrial Production (y-o-y growth)) append
	
	xtscc `dep' c.dh#c.above_fiscal c.dl#c.above_fiscal c.dh#c.below_fiscal c.dl#c.below_fiscal c pr_change mp_gdp vix_level c.month#code, fe lag(10)
	outreg2 using table4.xls, bdec(3)  addstat ("R-squared", e(r2_w)) ctitle(Industrial Production (y-o-y growth)) append
		
	drop dh dl
	drop above_fiscal below_fiscal emergency_fiscal demand_fiscal
}



